unit sqWaveMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, DlsrLib_TLB, Buttons;

type
  TForm1 = class(TForm)
    SR: TDriverLINXSR;
    Label1: TLabel;
    cmdOpen: TButton;
    cmdStart: TButton;
    cmdStop: TButton;
    GroupBox1: TGroupBox;
    opt1K: TRadioButton;
    opt5K: TRadioButton;
    devNum: TComboBox;
    txtStatus: TEdit;
    BitBtn1: TBitBtn;
    txtWiring: TEdit;
    Label2: TLabel;
    Channel: TComboBox;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure cmdOpenClick(Sender: TObject);
    procedure cmdStartClick(Sender: TObject);
    procedure cmdStopClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
// populate combo box with legal values
devNum.Items.Insert(0,'0');
devNum.Items.Insert(1,'1');
devNum.Items.Insert(2,'2');
devNum.Items.Insert(3,'3');
devNum.Items.Insert(4,'4');
devNum.Items.Insert(5,'5');
// set combo box equal to first entry
devnum.ItemIndex := 0;
//
txtWiring.Text := 'Look for Square Wave at output of Selected CT Channel';
// populate channel list box with legal values for a KPCI-3140
Channel.Items.Insert(0,'0');
Channel.Items.Insert(1,'1');
Channel.Items.Insert(2,'2');
Channel.Items.Insert(3,'3');
Channel.Items.Insert(4,'4');
Channel.Items.Insert(5,'5');
Channel.Items.Insert(6,'6');
Channel.Items.Insert(7,'7');




end;

procedure TForm1.cmdOpenClick(Sender: TObject);
var
DeviceNumber : Integer;
begin
DeviceNumber := devNum.ItemIndex;  // since our index equals our values
// don't have to do a string to value conversion of the text
with SR do begin
   Req_DLL_Name := 'kpci3140';
   Req_mode := DL_OTHER;
   Req_op := DL_INITIALIZE;
   Req_subsystem := DL_DEVICE;
   Req_device := DeviceNumber;
   Refresh;
end;
If (SR.Res_result = DL_NoErr) Then
     begin
       cmdStart.Enabled := True;
       txtStatus.Text := SR.Message;
     end
Else
txtStatus.Text := SR.Message;

form1.SetFocus;
end;

procedure TForm1.cmdStartClick(Sender: TObject);
var
Period : Single;
begin
// assign a value to Period based on the Option buttons on the form
if opt1K.Checked = True then
Period := 0.001   // 1 KHz
else
Period := 0.0002;   // 5 KHz
// set up a square wave task
With SR do begin
Req_op := DL_START;
Req_subsystem := DL_CT;
Req_mode := DL_POLLED;
Sel_buf_N := 0;
Sel_chan_N := 0;
Evt_Str_type := DL_COMMAND;
Evt_Tim_type := DL_RATEEVENT;
Evt_Tim_rateChannel := Channel.ItemIndex;
Evt_Tim_rateClock := DL_INTERNAL1;
Evt_Tim_rateGate := DL_DISABLED;
Evt_Tim_rateMode := DL_SQWAVE;
Evt_Tim_rateOutput := CT_Output_HiActive;
Evt_Tim_ratePeriod := DLSecs2Tics(Evt_Tim_rateChannel, Period);
//Evt_Tim_rateOnCount := .DLSecs2Tics(Evt_Tim_rateChannel, Duty);
Evt_Tim_ratePulses := 0;
Evt_Stp_type := DL_NULLEVENT;
Refresh;
end;

If SR.Res_result = DL_NoErr Then
begin
cmdStop.Enabled := True;
cmdStart.Enabled := False;
txtStatus.Text := SR.Message;
end
Else
txtStatus.Text := SR.Message

end;

procedure TForm1.cmdStopClick(Sender: TObject);
begin
With SR do begin
Req_op := DL_STOP;
Refresh;
end;  // with SR
cmdStop.Enabled := False;
cmdStart.Enabled := True;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
beep();
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
// stop any task that could be active
With SR do begin
Req_op := DL_STOP;
Refresh;
end;  // with SR
// unload the driver
SR.Req_DLL_name := '';  // empty string
end;

end.
